/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import io.github.fabricators_of_create.porting_lib.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.class_1074;
import net.minecraft.class_1767;
import net.minecraft.class_1780;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;

public class ColorAttribute
implements ItemAttribute {
    private class_1767 color;

    public ColorAttribute(class_1767 color) {
        this.color = color;
    }

    private static Collection<class_1767> findMatchingDyeColors(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        class_1767 color = TagUtil.getColorFromStack((class_1799)stack);
        if (color != null) {
            return Collections.singletonList(color);
        }
        HashSet<class_1767> colors = new HashSet<class_1767>();
        if (stack.method_7909() instanceof class_1781 && nbt != null) {
            class_2499 listnbt = nbt.method_10562("Fireworks").method_10554("Explosions", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                colors.addAll(ColorAttribute.getFireworkStarColors(listnbt.method_10602(i)));
            }
        }
        if (stack.method_7909() instanceof class_1780 && nbt != null) {
            colors.addAll(ColorAttribute.getFireworkStarColors(nbt.method_10562("Explosion")));
        }
        Arrays.stream(class_1767.values()).filter(c -> CatnipServices.REGISTRIES.getKeyOrThrow(stack.method_7909()).method_12832().startsWith(c.method_7792() + "_")).forEach(colors::add);
        return colors;
    }

    private static Collection<class_1767> getFireworkStarColors(class_2487 compound) {
        HashSet<class_1767> colors = new HashSet<class_1767>();
        Arrays.stream(compound.method_10561("Colors")).mapToObj(class_1767::method_7786).forEach(colors::add);
        Arrays.stream(compound.method_10561("FadeColors")).mapToObj(class_1767::method_7786).forEach(colors::add);
        return colors;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack, class_1937 level) {
        return ColorAttribute.findMatchingDyeColors(itemStack).stream().anyMatch(arg_0 -> this.color.equals(arg_0));
    }

    @Override
    public String getTranslationKey() {
        return "color";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{class_1074.method_4662((String)("color.minecraft." + this.color.method_7792()), (Object[])new Object[0])};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.HAS_COLOR;
    }

    @Override
    public void save(class_2487 nbt) {
        nbt.method_10569("color", this.color.method_7789());
    }

    @Override
    public void load(class_2487 nbt) {
        if (nbt.method_10545("color")) {
            this.color = class_1767.method_7791((int)nbt.method_10550("color"));
        }
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new ColorAttribute(class_1767.field_7945);
        }

        @Override
        public List<ItemAttribute> getAllAttributes(class_1799 stack, class_1937 level) {
            ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>();
            for (class_1767 color : ColorAttribute.findMatchingDyeColors(stack)) {
                list.add(new ColorAttribute(color));
            }
            return list;
        }
    }
}

